#!/usr/bin/python3
# -*- coding: utf-8 -*-

import cgi, os, html, datetime, uuid, json

print("Content-Type: application/json; charset=utf-8\n")

base_dir = "/home/flowserv.helioho.st/httpdocs/splint/uploads"
os.makedirs(base_dir, exist_ok=True)

# Crée un dossier de session unique
session_id = datetime.datetime.now().strftime("%Y%m%d_%H%M%S_") + str(uuid.uuid4())[:8]
user_dir = os.path.join(base_dir, session_id)
os.makedirs(user_dir, exist_ok=True)

form = cgi.FieldStorage()
if "files" not in form:
    print(json.dumps({"error": "Aucun fichier reçu."}))
    exit()

files = form["files"]
if not isinstance(files, list):
    files = [files]

saved = []
for f in files:
    if f.filename:
        filename = os.path.basename(f.filename)
        with open(os.path.join(user_dir, filename), "wb") as out:
            out.write(f.file.read())
        saved.append(filename)

print(json.dumps({"session_id": session_id, "files": saved}, ensure_ascii=False))
